class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'CNET News'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''


    remove_tags = [dict(name='div', attrs={'class':['datestamp','postByline','socialBadges','editorBio','cnet-image-div image-MEDIUM float-right','cnet-image-div image-REGULAR float-none','cnet-image-div image-MEDIUM float-left','cnet-image-div image-LARGE2 float-none']}),
                    dict(name='div', attrs={'id':'tweetmemeAndFacebook'}),
                     dict(name='ul', attrs={'class':'contentTools'}),
                     dict(name='ol', attrs={'id':['addStories']}),
                     dict(name=['img','newselement','h4'])
                  ]
    keep_only_tags = dict(name='div', attrs={'class':'txtWrap'})

    feeds = [(u'News', u'http://news.cnet.com/2547-1_3-0-20.xml')]

    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds